%% GMM estimation

clc
close all
clear all
path(pathdef)

addpath ./functions/

rng(1) % Set randomization seed

%% Load Data Moments

load ../../'Data Moments'/target_data.mat

%% Calibrated parameters
beta    = 0.99;         % Discount factor
th_n_ss = 0.03624178;	% Non-OPEC extraction rate
th_o_ss = 0.01794643;   % OPEC extraction rate
MS_o    = 0.42270546;   % OPEC's market share
eta     = 6.11;         % Structural parameter - eta
lambda  = .07930421;    % Structural parameter - lambda
R_o     = 0.028643;     % Share of oil revenues out of world GDP
gamma   = 2;            % CRRA parameter
L       = 1/3;          % Steady state labor supply
alpha   = 1/3;          % Cobb-Douglas parameter on capital
delta   = 0.1;          % Depreciation rate on capital
nu      = 0.5;          % Labor supply elasticity
y       = [beta, th_n_ss, th_o_ss, MS_o, lambda, eta, R_o, gamma, L, alpha, delta, nu]; % Set of calibrated parameters

%% GMM estimation

cd ./dynare_codes/ % Changing directory so dynare files and other mat files are saved there


options = optimset('LargeScale', 'off',  'maxfunevals', 2000, 'PlotFcns',...
                {@optimplotx, @optimplotfval});
 
% Initial guess for estimated parameters
x_0(1) = log(0.2); % log(epsilon)
x_0(2) = log(0.2/0.8); % eig a 1
x_0(3) = log(0.2/0.7); % eig a 2
x_0(4) = log(0.2/0.8); % eig po 1
x_0(5) = log(0.2/0.7); % eig po 2
x_0(6) = log(0.05); % log(var_po)
x_0(7) = log(0.02); % log(var_a)

W = diag(std_moments.^(-2)); % Weighting matrix for GMM procedure

[GMM_est, fval] = fminsearch(@(x) GMM_res(x, y, moments, W, N_variables ,N_ll), x_0, options);
[GMM_est, fval] = fminsearch(@(x) GMM_res(x, y, moments, W, N_variables ,N_ll), GMM_est, options);

x = GMM_est;

% Transforming x back to structural parameters:
x(1) = exp(x(1))/(1+exp(x(1)));                       % epsilon
lambda(1:2) = (1 - 2 * exp(x(2:3))./(1+exp(x(2:3)))); % rhos eigenvalues
x(2) = lambda(1) + lambda(2);                         % rho_a1
x(3) = - lambda(1) * lambda(2);                       % rho_a2

lambda(1:2) = (1 - 2 * exp(x(4:5))./(1+exp(x(4:5)))); % rhos eigenvalues
x(4) = lambda(1) + lambda(2);                         % rho_po1
x(5) = - lambda(1) * lambda(2);                       % rho_po2

x(6:7) = 10^(-7) + exp(x(6:7));                       % var_po var_a
x(6:7) = min(x(6:7), 5);

parameters = [y,x];
                         
%% Compute standard errors on estimated parameters


evalc('model_moments = Model_Moments(parameters, N_variables, N_ll);');

evalc('D = get_gradient_gmm(parameters, N_variables, N_ll);');


V = (D * W * D') \ (D * W * S0_delta * W' * D') / (D * W * D');
V = V / T;
std_error = diag(V).^(1/2);

cd ../
save ../../'Estimation Results'/Model_w_cost_shocks parameters psi GMM_est moments S0_delta D W std_moments T N_variables N_ll fval std_error model_moments
